<?php

namespace App\Http\Controllers;

use App\Expense;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Exp;

class ExpenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //

        $query = Expense::query()
            ->where("company_id","=",auth()->user()->company_id)
            ->orderBy('id','DESC');

        $start = $request->input("start_date");
        $end = $request->input("end_date");

        if ($start && $end) {
            $query = $query->whereBetween("expense_date", [$start, $end]);
        }

        $expenses = $query->get();
//        return auth()->user();
        $church = auth()->user()->company_id;
        return view('expenses.index',compact('expenses','church'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $expense = new Expense();
//        $expense->company_id = $request->church;
        $expense -> company_id = auth()->user()->company_id;
        $expense->expense_name = $request->expenseName;
        $expense->expense_category_id = $request->expenseCategory;
        $expense->amount = $request->amount;
        $expense->description = $request->description;
        $expense->requested_by = $request->requestedBy;
        $expense->expense_date = $request->expenseDate;



        $expense->save();

        return redirect()->back()->with(['success' => 'Expense Category Created Successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $expense = Expense::query()->findOrFail($request->input('expenseId'));
//        $expense -> company_id = auth()->user()->company_id;
        $expense -> expense_name = $request -> expenseName;
        $expense->expense_category_id = $request->expenseCategory;
        $expense->amount = $request->amount;
        $expense->description = $request->description;
        $expense->requested_by = $request->requestedBy;
        $expense->expense_date = $request->expenseDate;
//        $expense->company_id = $request->church;


        $expense->save();

        return redirect()->back()->with(['success' => 'Expense Updated Successfully']);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        //
        $expense = Expense::find($id);
        $expense->delete();
        return redirect()->back()->with(['success' => 'Expense Category Deleted Successfully']);
    }
}
