<?php

namespace App\Http\Controllers;

use App\ExpenseCategory;
use Illuminate\Http\Request;

class ExpenseCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

        $expcats = ExpenseCategory::query()->where("company_id","=",auth()->user()->company_id)->orderBy('id','DESC')->get();
        $church = auth()->user()->company_id;
        return view('expenseCategory.index', compact('expcats','church'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $expenseCategory = new ExpenseCategory();
        $expenseCategory -> company_id = auth()->user()->company_id;
        $expenseCategory -> category_name = $request->categoryName;
        $expenseCategory -> save();
        return redirect()->back()->with(['success' => 'Expense Category Created Successfully']);

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //

        $expenseCategory = ExpenseCategory::FindorFail($request->input('expenseCategoryId'));
        $expenseCategory -> category_name = $request->categoryName;
        $expenseCategory -> save();

        return redirect()->back()->with(['success' => 'Expense Category Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        //
        $expenseCategory = ExpenseCategory::find($id);
        $expenseCategory -> delete();
        return redirect()->back()->with(['success' => 'Expense Category Deleted Successfully']);
    }
}
