<?php


namespace App\Http\Controllers;

use App\Admin;
use App\Company;
use App\Individual;
use App\Membership;
use App\OfferingType;
use App\Small_group;
use App\TitheAndOffering;
use App\User;
use App\Visit;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Exception;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Spatie\Permission\Models\Permission;
use Yajra\DataTables\Facades\DataTables;

class DashboardController extends Controller
{
    function random_color_part()
    {
        return str_pad(dechex(mt_rand(0, 255)), 2, '0', STR_PAD_LEFT);
    }

    function random_color()
    {
        return "#" . $this->random_color_part() . $this->random_color_part() . $this->random_color_part();
    }


    public function index()
    {

        $collect = collect();
        $collect2 = collect();
        $data = OfferingType::query()->where("CompanyId", "=", auth()->user()->company_id)->get();

        $colors = array("#f56954", "#00a65a", "#f39c12", "#47c664", "#e8bc3a", "#de505e", "#ea5285", "#c1c7d1", "#2aa2b8", "#607d8b", "#15c5c6", "#7a58b8", "#03a9f4", "#ea5285", "#c99111");

        foreach ($data as $key => $d) {


            $list = TitheAndOffering::query()
                ->when(auth()->user()->company_id, fn(Builder $query) => $query->where("CompanyId", "=", auth()->user()->company_id))
                ->where("OfferingTypeId", "=", $d->id)
                ->groupByRaw("MONTH(Date)")->selectRaw("sum(Amount) as totalAmount,month(Date) as month")
                ->whereYear('Date', '=', date('Y'))
                ->get();
            $sum = TitheAndOffering::query()
                ->whereYear('Date', '=', date('Y'))
                ->where("OfferingTypeId", "=", $d->id)->sum("Amount");

            $months = collect();

            for ($i = 1; $i <= 12; $i++) {
                $dis = $list->where("month", "=", $i)->first();

                $month = date('F', mktime(0, 0, 0, $i, 1, date('Y')));

                if ($dis) {
                    $months->add(array(
                        "totalAmount" => $dis->totalAmount,
                        "month" => $month
                    ));
                } else {
                    $months->add(array(
                        "totalAmount" => 0,
                        "month" => $month
                    ));

                }
            }


            $color = $key >= count($colors) ? $this->random_color() : $colors[$key];

            $collect->add(array("id" => $d->id, "name" => $d->OfferingName, "color" => $color, "data" => $months));
            $collect2->add(array("id" => $d->id, "name" => $d->OfferingName, "color" => $color, "sum" => $sum));
        }

        $offeringAmount = TitheAndOffering::query()->where("CompanyId", "=", auth()->user()->company_id)->sum('Amount');
        $totalMembers = \App\Membership::query()->where("company_id", "=", auth()->user()->company_id)->count();
        $totalSmallGroups = \App\Small_group::query()->where("company_id", "=", auth()->user()->company_id)->count();
        $totalUsers = \App\User::query()->where("company_id", "=", auth()->user()->company_id)->count();
        return view('home', compact('collect', 'collect2', 'offeringAmount', 'totalMembers', 'totalSmallGroups', 'totalUsers'));
    }


    private function addAllPermissions(User $user)
    {
        $user->permissions()->sync(Permission::all()->pluck("id"));
    }


//    public function migrate(): string
//    {
//        $list = Company::query()->whereNotNull("password")->get();
//        DB::beginTransaction();
//        foreach ($list as $m){
//            if(User::query()->where("company_id","=",$m->id)->count() <= 0){
//
//                $user = new User();
//                $user->name = $m->name;
//                $user->email = $m->email;
//                $user->code = $m->code;
//                $user->company_id = $m->id;
//                $user->password = bcrypt($m->password);
//                $user->save();
//                $this->addAllPermissions($user);
//            }
//        }
//        DB::commit();
//
//        return "migrated successfully";
//    }


    public function addCompany(Request $request)
    {
        DB::beginTransaction();
        $ind = new Company();
        $ind->name = $request->input("name");
        $ind->tin = $request->input("tin");
        $ind->address = $request->input("address");
        $ind->email = $request->input("email");

        $find = Company::where("tin", "=", $ind->tin)->first();

        if ($find == null) {
            $ind->save();
            $code = "C" . str_pad($ind->id, 5, "0", STR_PAD_LEFT);
            $ind->update(['code' => $code]);

            $user = new User();
            $user->name = $ind->name;
            $user->email = $ind->email;
            $user->code = $code;
            $user->company_id = $ind->id;
            $user->password = bcrypt($request->input("password"));
            $this->addAllPermissions($user);

            DB::commit();
        }
        return redirect("/admin");


    }


    public function homepage(Request $request)
    {
        $start = $request->input("start_date");
        $end = $request->input("end_date");
//
//        $query = Visit::with("company", "individual")
//            ->where("company_id","=",auth()->user()->company_id);
//

//
//        $q = null;
//        if ($request->has("query")) {
//            $q = $request->get("query");
//            $query = $query->whereHas("individual", function (Builder $builder) use ($q) {
//                $builder->where('names', 'LIKE', "%$q%");
//            });
//        }

        if ($request->ajax()) {
            $data = Visit::query()->with(["individual"])
                ->where("visits.company_id", "=", auth()->user()->company_id);
            if ($start && $end) {
                $data = $data->whereDate("created_at", ">=", $start)->whereDate("created_at", "<=", $end);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($row) {

                    $btn = '<a href="javascript:void(0)" class="edit btn btn-primary btn-sm">View</a>';

                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }


        return view('homepage', [
            "company" => auth()->user()->company,
        ]);
    }


    public function admin(Request $request)
    {


        $query = Company::query();


        $q = null;
        if ($request->has("query")) {
            $q = $request->get("query");
            $query = $query->where('name', 'LIKE', "%$q%");
        }


        return view('administrator', [
            "admin" => Admin::where("username", "=", session()->get("admin"))->first(),
            "list" => $query->orderByDesc("id")->paginate(20)->appends(['query' => $q])
        ]);
    }


    public function export(Request $request)
    {

        $start = $request->input("start_date");
        $end = $request->input("end_date");

        $query = Visit::with("company", "individual")
            ->whereHas("company", function (Builder $builder) {
                $builder->where('code', '=', session()->get("company"));
            });

        if ($start && $end) {
            $query = $query->whereBetween("created_at", [$start, $end]);
        }


        if ($request->has("query")) {
            $q = $request->get("query");
            $query = $query->whereHas("individual", function (Builder $builder) use ($q) {
                $builder->where('names', 'LIKE', "%$q%");
            });
        }


        $headers = ["Names", "Phone", "Date", "Temperature", "District", "Sector", "Cell", "Village", "Vaccination", "Vaccination code"];

        $data = $query->get();
        $phpExcel = new Spreadsheet();
        $phpExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', strtoupper($headers[0]))
            ->setCellValue('B1', strtoupper($headers[1]))
            ->setCellValue('C1', strtoupper($headers[2]))
            ->setCellValue('D1', strtoupper($headers[3]))
            ->setCellValue('E1', strtoupper($headers[4]))
            ->setCellValue('F1', strtoupper($headers[5]))
            ->setCellValue('G1', strtoupper($headers[6]))
            ->setCellValue('H1', strtoupper($headers[7]))
            ->setCellValue('I1', strtoupper($headers[8]))
            ->setCellValue('J1', strtoupper($headers[9]));
        $col = 2;
        foreach ($data as $player) {
            try {
                $phpExcel->setActiveSheetIndex(0)
                    ->setCellValueByColumnAndRow(1, $col, $player->individual->names)
                    ->setCellValueByColumnAndRow(2, $col, $player->individual->phone)
                    ->setCellValueByColumnAndRow(3, $col, $player->created_at)
                    ->setCellValueByColumnAndRow(4, $col, $player->temperature)
                    ->setCellValueByColumnAndRow(5, $col, $player->individual->village->cell->sector->district->name ?? "")
                    ->setCellValueByColumnAndRow(6, $col, $player->individual->village->cell->sector->name ?? "")
                    ->setCellValueByColumnAndRow(7, $col, $player->individual->village->cell->name ?? "")
                    ->setCellValueByColumnAndRow(8, $col, $player->individual->village->name ?? "")
                    ->setCellValueByColumnAndRow(9, $col, $player->vaccination)
                    ->setCellValueByColumnAndRow(10, $col, $player->vaccination_code);
            } catch (Exception $e) {
            }
            $col++;
        }
        $writer = new Xlsx($phpExcel);
        try {
            $writer->save(public_path() . '/files/template.xlsx');
        } catch (\PhpOffice\PhpSpreadsheet\Writer\Exception $e) {
        }
        $file = public_path() . "/files/template.xlsx";
        return response()->download($file);

    }

    public function preparePieData()
    {
        $startDate = \request('start_date');
        $endDate = \request('end_date');
        $offeringTypeId = \request('offering_type_id');

        $query = TitheAndOffering::query()
            ->with('member.smallGroup')
            ->when(auth()->user()->company_id, fn(Builder $query) => $query->where("CompanyId", "=", auth()->user()->company_id))
            ->when($startDate, fn(Builder $query) => $query->whereDate('Date', '>=', $startDate))
            ->when($endDate, fn(Builder $query) => $query->whereDate('Date', '<=', $endDate))
            ->when($offeringTypeId, fn(Builder $query) => $query->where('OfferingTypeId', '=', $offeringTypeId));

        $data = $query->get()
            ->groupBy('member.small_group_id')
            ->map(function ($items, $key) {
                $small_group = Small_group::find($key);
                return [
                    'label' => $small_group ? $small_group->group_name : 'Unknown',
                    'value' => $items->sum('Amount')
                ];
            })->values();

        return response()->json([
            'labels' => $data->pluck('label'),
            'datasets' => [
                [
                    'data' => $data->pluck('value'),
                    'backgroundColor' => collect(range(0, $data->count()))->map(function () {
                        return '#' . substr(md5(mt_rand()), 0, 6);
                    })
                ]
            ]
        ]);
    }

    public function prepareBarChartData()
    {
        $data = Small_group::leftJoin('memberships', 'small_groups.id', '=', 'memberships.small_group_id')
            ->leftJoin('statuses', 'memberships.status_id', '=', 'statuses.id')
            ->whereIn('statuses.statusName', ['Active', 'Inactive'])
            ->when(auth()->user()->company_id, fn(Builder $query) => $query->where("small_groups.company_id", "=", auth()->user()->company_id))
            ->select('small_groups.group_name')
            ->selectRaw("SUM(CASE WHEN statuses.statusName = 'Active' THEN 1 ELSE 0 END) as active_members")
            ->selectRaw("SUM(CASE WHEN statuses.statusName = 'Inactive' THEN 1 ELSE 0 END) as inactive_members")
            ->groupBy('small_groups.group_name')
            ->orderBy('small_groups.group_name') // Or any other relevant field
            ->get()
            ->map(function ($item) {
                return [
                    'group_name' => $item->group_name,
                    'active' => $item->active_members,
                    'inactive' => $item->inactive_members,
                ];
            });

        return response()->json([
            'labels' => $data->pluck('group_name'),
            'datasets' => [
                [
                    'label' => 'Active Members',
                    'data' => $data->pluck('active'),
                    'backgroundColor' => 'rgba(44, 164, 68, 1)', // Example color
                    'borderColor' => 'rgba(44, 164, 68, 0.8)',     // Example color
                    'borderWidth' => 1,
                ],
                [
                    'label' => 'Inactive Members',
                    'data' => $data->pluck('inactive'),
                    'backgroundColor' => 'rgba(220, 53, 69, 1)', // Example color
                    'borderColor' => 'rgba(255, 99, 132, 1)',     // Example color
                    'borderWidth' => 1,
                ],
            ],
        ]);
    }


}
