<?php

namespace App\Http\Controllers\Auth;

use App\Client;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    public function index()
    {
        return view('welcome');
    }


    /**
     * Show the application's login form.
     *
     */
    public function showLoginForm()
    {
        return $this->index();
    }


    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

        $this->middleware('guest')->except('logout');
    }

    public function username(): string
    {
        return 'email';
    }

    public function login(Request $request)
    {
        $this->validateLogin($request);

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if (method_exists($this, 'hasTooManyLoginAttempts') && $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);
            $this->sendLockoutResponse($request);
        }

        $username = $request->input('email');
        $password = $request->input('password');
        $remember = $request->input('remember');

        $client = User::whereNotNull('password')
            ->where(function (Builder $builder) use ($username) {
                $builder->where('code', '=', $username)
                    ->orWhere('email', '=', $username);
            })->first();


        if ($client) {

//            if (is_null($client->verified_at) && $client->is_active) {
//                return redirect()->route('client.otp.form')->with(['phone' => encrypt($client->phone_number)]);
//            }

            if (Hash::check($password, $client->password)) {

                if (!$client->is_active) {
                    return back()->withInput($request->only('username'))
                        ->withErrors(['username' => 'This account is not active. please contact iHuzo admin']);
                }

                if ($this->guard()->loginUsingId($client->id, true)) {
                    return $this->sendLoginResponse($request);
                }
            }
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);
        return $this->sendFailedLoginResponse($request);
    }

}
