<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;

class TitheTemplateExport implements FromCollection, WithTitle, WithHeadings, WithEvents, ShouldAutoSize
{

    public function collection(): Collection
    {
        return collect();
    }

    public function registerEvents(): array
    {
        return [
        AfterSheet::class => function(AfterSheet $event) {

            $cellRange = sprintf('A1:Z1'); // All headers
            $event->sheet->getDelegate()->getStyle($cellRange)->getFont()->setSize(16);
        }];
    }

    public function headings(): array
    {
        return array("Date & Time","Names","Phone","Type","Amount");
    }

    public function title(): string
    {
        return "Tithe and Offering Template";
    }


}
