<?php

namespace App\Exports;

use App\TitheAndOffering;
use App\TitheOfferingBase;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class TitheOfferingExport implements FromQuery, WithTitle, WithHeadings, ShouldAutoSize, WithMapping, WithStyles, WithColumnFormatting, WithEvents
{
    use Exportable;

    private ?string $startDate;
    private ?string $endDate;
    private ?int $titheBaseId;

    public function __construct(?string $startDate, ?string $endDate, ?int $titheBaseId)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
        $this->titheBaseId = $titheBaseId;
    }

    public function query()
    {
        return TitheAndOffering::query()
            ->with(['offering', 'payment', 'member.smallgroups'])
            ->when($this->startDate, fn($query, $startDate) => $query->whereDate('created_at', '>=', $startDate))
            ->when($this->endDate, fn($query, $endDate) => $query->whereDate('created_at', '<=', $endDate))
            ->when($this->titheBaseId, fn($query, $titheBaseId) => $query->where('tithe_offering_base_id', $titheBaseId));
    }


    public function headings(): array
    {
        return [
            "Date",
            "Member Name",
            "member Phone",
            "Offering Type",
            "Amount",
            "Payment Method",
            "Small Group"
        ];
    }

    public function title(): string
    {
        return "Tithe and Offering";
    }


    /**
     * @param TitheAndOffering $row
     * @return array
     */
    public function map($row): array
    {
        return [
            $row->Date->format('Y-m-d'),
            $row->member_names,
            $row->member_phone,
            $row->offering->OfferingName,
            $row->Amount,
            $row->payment->PaymentOption,
            $row->member?->smallgroups?->group_name ?? 'N/A'
        ];
    }

    /**
     * Apply custom metadata and styling after the sheet is created.
     */
    public function afterSheet(AfterSheet $event): void
    {
     /*   $model = TitheOfferingBase::query()->find($this->titheBaseId);
        // Add custom metadata at the top of the sheet
        $event->sheet->getDelegate()->setCellValue('G2', 'Date:');
        $event->sheet->getDelegate()->setCellValue('G3', 'Done By: ');
        $event->sheet->getDelegate()->setCellValue('G4', 'Source: ');
        $event->sheet->getDelegate()->setCellValue('G5', 'Total Records: ');
        $event->sheet->getDelegate()->setCellValue('G6', 'Total Amount: ');
        $event->sheet->getDelegate()->setCellValue('G7', 'Status: ');

        // Add custom data to the cells
        $event->sheet->getDelegate()->setCellValue('H2', $model->created_at->format('Y-m-d'));
        $event->sheet->getDelegate()->setCellValue('H3', $model->user->name);
        $event->sheet->getDelegate()->setCellValue('H4', $model->source);
        $event->sheet->getDelegate()->setCellValue('H5', $event->sheet->getDelegate()->getHighestDataRow() - 5);
        $event->sheet->getDelegate()->setCellValue('H6', '=SUM(E2:E' . ($event->sheet->getDelegate()->getHighestDataRow() - 4) . ')');
        $event->sheet->getDelegate()->setCellValue('H7', $model->status);

        // You can apply custom styling if needed:
        $event->sheet->getDelegate()->getStyle('G2:G7')->getFont()->setBold(true);*/
    }


    public function styles(Worksheet $sheet): array
    {
        return [
            // Style the first row as bold text.
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'E' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $this->afterSheet($event);
            }
        ];
    }
}
