<?php

namespace App\Exports;

use App\Membership;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithTitle;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class MembershipExport implements FromQuery, WithMapping, WithTitle, WithStyles, ShouldAutoSize, WithHeadings
{
    use Exportable;

    public function query()
    {
        return Membership::query()
            ->with(['smallGroup', 'villages.cell.sector.district.province', 'categories', 'statuses'])
            ->where('company_id', '=', auth()->user()->company_id);
    }


    /**
     * @param Membership $row
     * @return array
     */
    public function map($row): array
    {
        return [
            $row->membership_date->format('Y-m-d'),
            $row->firstname,
            $row->lastname,
            $row->phone_number,
            $row->phone_number_2,
            $row->smallGroup->name,
            $row->categories->categoryName,
            $row->employment_status,
            $row->marital_status,
            $row->statuses->statusName,
            $row->districts->province->name ?? 'N/A',
            $row->districts->name ?? 'N/A',
            $row->sectors->name ?? 'N/A',
            $row->cells->name ?? 'N/A',
            $row->villages->name ?? 'N/A',
            $row->church_register_page ?? 'N/A'
        ];
    }

    public function styles(Worksheet $sheet): array
    {
        return [
            1 => [
                'font' => ['bold' => true],
                'alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER]
            ],
            'A:P' => [
                'alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT]
            ]
        ];
    }

    public function title(): string
    {
        return "Membership";
    }


    public function headings(): array
    {
        return [
            'Membership Date',
            'First Name',
            'Last Name',
            'Phone Number 1',
            'Phone Number 2',
            'Small group',
            'Category',
            'Employment Status',
            'Martial Status',
            'Status',
            'Province',
            'District',
            'Sector',
            'Cell',
            'Village',
            'Book Page'
        ];
    }
}
