<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\ExpenseCategory
 *
 * @property int $id
 * @property string $category_name
 * @property int|null $company_id
 * @property-read \App\Company|null $company
 * @method static \Illuminate\Database\Eloquent\Builder|ExpenseCategory newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ExpenseCategory newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ExpenseCategory query()
 * @method static \Illuminate\Database\Eloquent\Builder|ExpenseCategory whereCategoryName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ExpenseCategory whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ExpenseCategory whereId($value)
 * @mixin \Eloquent
 */
class ExpenseCategory extends Model
{
    //

    protected $table = "expenses_category";
    public $timestamps = false;

    public function company(){
        return $this->belongsTo(Company::class,"company_id");
    }
}
