<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Expense
 *
 * @property int $id
 * @property int|null $expense_category_id
 * @property string $expense_name
 * @property int $amount
 * @property string $description
 * @property string $requested_by
 * @property int|null $company_id
 * @property string $expense_date
 * @property-read \App\Company|null $churches
 * @property-read \App\ExpenseCategory|null $expenseCat
 * @method static \Illuminate\Database\Eloquent\Builder|Expense newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Expense newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Expense query()
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereExpenseCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereExpenseDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereExpenseName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereRequestedBy($value)
 * @mixin \Eloquent
 */
class Expense extends Model
{
    //
    public $timestamps = false;

    protected $fillable = ['expense_name','expense_category_id','amount','company_id','description','requested_by','expense-date'];


    public function expenseCat(){
        return $this->belongsTo(ExpenseCategory::class,'expense_category_id');
    }

    public function churches(){
        return $this->belongsTo(Company::class,'company_id');
    }
}
