<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Storage;

class DeleteOldFiles extends Command
{
    protected $signature = 'files:delete-old';
    protected $description = "Delete files older than a specified number of days from the storage folder";

    // Execute the console command.
    public function handle()
    {
        $hours = 5; // Get the number of hours from the argument

        // Get all files in the directory
        $files = Storage::files('uploads/tithes_preview');

        // Define the date threshold
        $threshold = Carbon::now()->subHours($hours);

        // Loop through the files and delete those older than the threshold
        foreach ($files as $file) {
            $fileDate = Carbon::createFromTimestamp(Storage::lastModified($file));

            if ($fileDate->lt($threshold)) {
                Storage::delete($file);
                $this->info("Deleted old file: $file");
            }
        }

        $this->info("Old files deleted successfully.");
    }
}
