<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Cell
 *
 * @property int $id
 * @property int $sector_id
 * @property string $name
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Membership> $memberships
 * @property-read int|null $memberships_count
 * @property-read \App\Sector $sector
 * @method static \Illuminate\Database\Eloquent\Builder|Cell newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Cell newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Cell query()
 * @method static \Illuminate\Database\Eloquent\Builder|Cell whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Cell whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Cell whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Cell whereSectorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Cell whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Cell extends Model
{
    //
    public function sector()
    {
        return $this->belongsTo(Sector::class);
    }


    public function memberships()
    {
        return $this->hasMany(Membership::class,'cell_id');
    }
}
